﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.Utilities;   

public partial class BioContactFollowups : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            HiddenFieldClearFlag.Value = "0";
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR REFERRALS";
    }

    public override string AppObjectCode()
    {
        return "EFR REFERRALS";
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonOK_Clear(object sender, EventArgs e)
    {
        GridViewReferralFollowUps.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";

    }

    public void FollowUps_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewReferralFollowUps.SelectedIndex = index;

            //int id = Convert.ToInt32(GridViewReferralFollowUps.SelectedValue);
            //calling the right page for different order lab order type
            //Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));

            Label fUpType = GridViewReferralFollowUps.SelectedRow.FindControl("LabelFollowupType") as Label;
            if (fUpType != null)
            {
                if (fUpType.Text.Equals("Biomonitoring"))
                {
                    int id = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ReferralId"].ToString());
                    //Response.Redirect(string.Format("LabOrder.aspx?activityId={0}", id));
                    Response.Redirect("Referral.aspx?referralId={0}&statusId=9999", id);

                }
                else if (fUpType.Text.Equals("Contact"))
                {
                    //Response.Redirect(string.Format("FragLabOrder.aspx?activityId={0}", id));
                    int referralId = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ReferralId"].ToString());
                    int contactId = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ContactId"].ToString());

                    Response.Redirect("ReferralContact.aspx?referralId={0}&contactId={1}", referralId, contactId);
                }
            }
            
        }

    }
}
